/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.core;

import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.PrettyPrintError;
import io.gitlab.jfronny.muscript.core.StackFrame;
import java.util.LinkedList;
import java.util.List;

public class LocationalException
extends RuntimeException {
    private final CodeLocation location;
    private final List<StackFrame> callStack = new LinkedList<StackFrame>();
    private String messageCache;

    public LocationalException(CodeLocation location) {
        this.location = location;
    }

    public LocationalException(CodeLocation location, String message) {
        super(message);
        this.location = location;
    }

    public LocationalException(CodeLocation location, String message, Throwable cause) {
        super(message, cause);
        this.location = location;
    }

    public LocationalException(CodeLocation location, Throwable cause) {
        super(cause);
        this.location = location;
    }

    @Override
    public String getLocalizedMessage() {
        return this.messageCache != null ? this.messageCache : (this.messageCache = this.asPrintable().toString());
    }

    public PrettyPrintError asPrintable() {
        return (this.location.source() == null ? PrettyPrintError.builder() : PrettyPrintError.builder(this.location)).setMessage(super.getMessage()).setCallStack(this.callStack).build();
    }

    public LocationalException appendStack(StackFrame frame) {
        this.messageCache = null;
        this.callStack.add(frame);
        return this;
    }
}

