/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.core;

import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.muscript.core.MuUtil;
import java.io.Closeable;
import java.io.IOException;

public class ExprWriter
implements Appendable,
Closeable {
    private final Appendable target;
    private final boolean compact;
    private int indent = 0;

    public static String write(ThrowingConsumer<ExprWriter, IOException> consumer, boolean compact) {
        StringBuilder sb = new StringBuilder();
        try (ExprWriter writer = new ExprWriter(sb, compact);){
            consumer.accept((Object)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write expression", e);
        }
        return sb.toString();
    }

    public ExprWriter(Appendable target, boolean compact) {
        this.target = target;
        this.compact = compact;
    }

    @Override
    public ExprWriter append(CharSequence csq) throws IOException {
        this.target.append(csq.toString().replace("\r", "").replace("\n", (CharSequence)(this.compact ? " " : "\n" + this.indent())));
        return this;
    }

    @Override
    public ExprWriter append(CharSequence csq, int start, int end) throws IOException {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public ExprWriter append(char c) throws IOException {
        switch (c) {
            case '\r': {
                break;
            }
            case '\n': {
                if (this.compact) {
                    this.target.append(" ");
                    break;
                }
                this.target.append("\n").append(this.indent());
                break;
            }
            default: {
                this.target.append(c);
            }
        }
        return this;
    }

    public ExprWriter appendLiteral(String s) throws IOException {
        if (!MuUtil.isValidId(s)) {
            if (s.contains("`")) {
                throw new IllegalArgumentException("Not a valid literal: " + s);
            }
            return this.append('`').append(s).append('`');
        }
        return this.append(s);
    }

    private String indent() {
        return " ".repeat(this.indent);
    }

    public ExprWriter increaseIndent() {
        this.indent += 2;
        return this;
    }

    public ExprWriter decreaseIndent() {
        if (this.indent <= 1) {
            throw new IllegalStateException("Attempted to decrease indent lower than 0");
        }
        this.indent -= 2;
        return this;
    }

    @Override
    public void close() {
        if (this.indent != 0) {
            throw new IllegalStateException("Attempted to close ExprWriter before end");
        }
    }
}

