/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.ast.dynamic;

import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.NullLiteral;
import io.gitlab.jfronny.muscript.ast.context.ExprUtils;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.Order;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public record ExprGroup(CodeLocation location, List<Expr> steps, DynamicExpr finish, @Nullable PackedArgs packedArgs, boolean fork) implements DynamicExpr
{
    public ExprGroup(CodeLocation location, List<Expr> expressions, @Nullable PackedArgs packedArgs, boolean fork) {
        this(location, expressions.subList(0, expressions.size() - 1), ExprUtils.asDynamic(expressions.getLast()), packedArgs, fork);
    }

    public static Expr of(CodeLocation location, List<Expr> expressions) {
        return ExprGroup.of(location, expressions, true);
    }

    public static Expr of(CodeLocation location, List<Expr> expressions, boolean fork) {
        if (expressions.isEmpty()) {
            return new NullLiteral(location);
        }
        if (!fork && expressions.size() == 1) {
            return expressions.getFirst();
        }
        return new ExprGroup(location, expressions, null, fork);
    }

    public Stream<Expr> stream() {
        return Stream.concat(this.steps.stream(), Stream.of(this.finish));
    }

    @Override
    public Order order() {
        return Order.Primary;
    }

    public record PackedArgs(List<Call.Argument> from, List<String> to, boolean variadic) {
    }
}

