/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.ast.context;

import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.muscript.ast.BoolExpr;
import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.Expr;
import io.gitlab.jfronny.muscript.ast.NullLiteral;
import io.gitlab.jfronny.muscript.ast.NumberExpr;
import io.gitlab.jfronny.muscript.ast.StringExpr;
import io.gitlab.jfronny.muscript.ast.bool.BoolAssign;
import io.gitlab.jfronny.muscript.ast.bool.BoolConditional;
import io.gitlab.jfronny.muscript.ast.bool.BoolLiteral;
import io.gitlab.jfronny.muscript.ast.bool.BoolUnpack;
import io.gitlab.jfronny.muscript.ast.context.TypeMismatchException;
import io.gitlab.jfronny.muscript.ast.dynamic.Bind;
import io.gitlab.jfronny.muscript.ast.dynamic.Call;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicAssign;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicCoerce;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicConditional;
import io.gitlab.jfronny.muscript.ast.dynamic.DynamicLiteral;
import io.gitlab.jfronny.muscript.ast.dynamic.ObjectLiteral;
import io.gitlab.jfronny.muscript.ast.dynamic.Variable;
import io.gitlab.jfronny.muscript.ast.number.NumberAssign;
import io.gitlab.jfronny.muscript.ast.number.NumberConditional;
import io.gitlab.jfronny.muscript.ast.number.NumberLiteral;
import io.gitlab.jfronny.muscript.ast.number.NumberUnpack;
import io.gitlab.jfronny.muscript.ast.string.Concatenate;
import io.gitlab.jfronny.muscript.ast.string.StringAssign;
import io.gitlab.jfronny.muscript.ast.string.StringCoerce;
import io.gitlab.jfronny.muscript.ast.string.StringConditional;
import io.gitlab.jfronny.muscript.ast.string.StringLiteral;
import io.gitlab.jfronny.muscript.ast.string.StringUnpack;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ExprUtils {
    private static final Set<String> allowedVariables = Set.of("date", "time", "enum", "listOf");

    public static DynamicExpr asDynamic(Expr expression) {
        DynamicExpr dynamicExpr;
        if ((expression = ExprUtils.unpack(expression)) instanceof DynamicExpr) {
            DynamicExpr dynamic = (DynamicExpr)expression;
            dynamicExpr = dynamic;
        } else {
            dynamicExpr = new DynamicCoerce(expression);
        }
        return dynamicExpr;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BoolExpr asBool(Expr expression) {
        Expr expr = ExprUtils.unpack(expression);
        Objects.requireNonNull(expr);
        Expr expr2 = expr;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolExpr.class, DynamicConditional.class, DynamicAssign.class, DynamicExpr.class, NullLiteral.class, StringExpr.class, NumberExpr.class}, (Object)expr2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                BoolExpr bool;
                BoolExpr boolExpr = bool = (BoolExpr)expr2;
                return boolExpr;
            }
            case 1: {
                BoolExpr boolExpr;
                DynamicConditional dynamicConditional = (DynamicConditional)expr2;
                try {
                    Object object = dynamicConditional.location();
                    CodeLocation location = object;
                    Object condition = object = dynamicConditional.condition();
                    Object ifTrue = object = dynamicConditional.ifTrue();
                    Object ifFalse = object = dynamicConditional.ifFalse();
                    boolExpr = new BoolConditional(location, (BoolExpr)condition, ExprUtils.asBool((Expr)ifTrue), ExprUtils.asBool((Expr)ifFalse));
                    return boolExpr;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: {
                BoolExpr boolExpr;
                DynamicAssign dynamicAssign = (DynamicAssign)expr2;
                {
                    Object object = dynamicAssign.location();
                    CodeLocation location = object;
                    Object left = object = dynamicAssign.variable();
                    Object right = object = dynamicAssign.value();
                    boolExpr = new BoolAssign(location, (String)left, ExprUtils.asBool((Expr)right));
                    return boolExpr;
                }
            }
            case 3: {
                DynamicExpr dynamic = (DynamicExpr)expr2;
                BoolExpr boolExpr = new BoolUnpack(dynamic);
                return boolExpr;
            }
            case 4: {
                NullLiteral nl = (NullLiteral)expr2;
                throw new TypeMismatchException("Expected boolean expression but got null");
            }
            case 5: {
                StringExpr string = (StringExpr)expr2;
                throw new TypeMismatchException("Expected boolean expression but got string");
            }
            case 6: 
        }
        NumberExpr number = (NumberExpr)expr2;
        throw new TypeMismatchException("Expected boolean expression but got number");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NumberExpr asNumber(Expr expression) {
        Expr expr = ExprUtils.unpack(expression);
        Objects.requireNonNull(expr);
        Expr expr2 = expr;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumberExpr.class, DynamicConditional.class, DynamicAssign.class, DynamicExpr.class, NullLiteral.class, StringExpr.class, BoolExpr.class}, (Object)expr2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                NumberExpr number;
                NumberExpr numberExpr = number = (NumberExpr)expr2;
                return numberExpr;
            }
            case 1: {
                NumberExpr numberExpr;
                DynamicConditional dynamicConditional = (DynamicConditional)expr2;
                try {
                    Object object = dynamicConditional.location();
                    CodeLocation location = object;
                    Object condition = object = dynamicConditional.condition();
                    Object ifTrue = object = dynamicConditional.ifTrue();
                    Object ifFalse = object = dynamicConditional.ifFalse();
                    numberExpr = new NumberConditional(location, (BoolExpr)condition, ExprUtils.asNumber((Expr)ifTrue), ExprUtils.asNumber((Expr)ifFalse));
                    return numberExpr;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: {
                NumberExpr numberExpr;
                DynamicAssign dynamicAssign = (DynamicAssign)expr2;
                {
                    Object object = dynamicAssign.location();
                    CodeLocation location = object;
                    Object left = object = dynamicAssign.variable();
                    Object right = object = dynamicAssign.value();
                    numberExpr = new NumberAssign(location, (String)left, ExprUtils.asNumber((Expr)right));
                    return numberExpr;
                }
            }
            case 3: {
                DynamicExpr dynamic = (DynamicExpr)expr2;
                NumberExpr numberExpr = new NumberUnpack(dynamic);
                return numberExpr;
            }
            case 4: {
                NullLiteral nl = (NullLiteral)expr2;
                throw new TypeMismatchException("Expected number expression but got null");
            }
            case 5: {
                StringExpr string = (StringExpr)expr2;
                throw new TypeMismatchException("Expected number expression but got string");
            }
            case 6: 
        }
        BoolExpr bool = (BoolExpr)expr2;
        throw new TypeMismatchException("Expected number expression but got boolean");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringExpr asString(Expr expression) {
        StringExpr stringExpr;
        Expr expr = ExprUtils.unpack(expression);
        Objects.requireNonNull(expr);
        Expr expr2 = expr;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringExpr.class, NumberLiteral.class, BoolLiteral.class, NullLiteral.class, DynamicConditional.class, BoolConditional.class, NumberConditional.class, DynamicAssign.class, DynamicExpr.class}, (Object)expr2, n)) {
            case 0: {
                StringExpr string = (StringExpr)expr2;
                stringExpr = string;
                return stringExpr;
            }
            case 1: {
                NumberLiteral number = (NumberLiteral)expr2;
                stringExpr = new StringLiteral(expression.location(), StringFormatter.toStringPrecise((double)number.value()));
                return stringExpr;
            }
            case 2: {
                BoolLiteral bool = (BoolLiteral)expr2;
                stringExpr = new StringLiteral(expression.location(), bool.value() ? "true" : "false");
                return stringExpr;
            }
            case 3: {
                NullLiteral nl = (NullLiteral)expr2;
                stringExpr = new StringLiteral(expression.location(), "null");
                return stringExpr;
            }
            case 4: {
                DynamicConditional dynamicConditional = (DynamicConditional)expr2;
                try {
                    Object object = dynamicConditional.location();
                    CodeLocation location = object;
                    Object condition = object = dynamicConditional.condition();
                    Object ifTrue = object = dynamicConditional.ifTrue();
                    Object ifFalse = object = dynamicConditional.ifFalse();
                    stringExpr = new StringConditional(location, (BoolExpr)condition, ExprUtils.asString((Expr)ifTrue), ExprUtils.asString((Expr)ifFalse));
                    return stringExpr;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 5: {
                BoolConditional boolConditional = (BoolConditional)expr2;
                {
                    Object object = boolConditional.location();
                    CodeLocation location = object;
                    Object condition = object = boolConditional.condition();
                    Object ifTrue = object = boolConditional.ifTrue();
                    Object ifFalse = object = boolConditional.ifFalse();
                    stringExpr = new StringConditional(location, (BoolExpr)condition, ExprUtils.asString((Expr)ifTrue), ExprUtils.asString((Expr)ifFalse));
                    return stringExpr;
                }
            }
            case 6: {
                NumberConditional numberConditional = (NumberConditional)expr2;
                {
                    Object object = numberConditional.location();
                    CodeLocation location = object;
                    Object condition = object = numberConditional.condition();
                    Object ifTrue = object = numberConditional.ifTrue();
                    Object ifFalse = object = numberConditional.ifFalse();
                    stringExpr = new StringConditional(location, (BoolExpr)condition, ExprUtils.asString((Expr)ifTrue), ExprUtils.asString((Expr)ifFalse));
                    return stringExpr;
                }
            }
            case 7: {
                DynamicAssign dynamicAssign = (DynamicAssign)expr2;
                {
                    Object object = dynamicAssign.location();
                    CodeLocation location = object;
                    Object left = object = dynamicAssign.variable();
                    Object right = object = dynamicAssign.value();
                    stringExpr = new StringAssign(location, (String)left, ExprUtils.asString((Expr)right));
                    return stringExpr;
                }
            }
            case 8: {
                DynamicExpr dynamic = (DynamicExpr)expr2;
                stringExpr = new StringUnpack(dynamic);
                return stringExpr;
            }
        }
        stringExpr = new StringCoerce(expression);
        return stringExpr;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Expr unpack(Expr expression) {
        Expr expr;
        Expr expr2 = expression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolUnpack.class, NumberUnpack.class, StringUnpack.class, DynamicCoerce.class, StringCoerce.class}, (Object)expr2, n)) {
            case -1: {
                throw new NullPointerException();
            }
            case 0: {
                DynamicExpr inner;
                BoolUnpack boolUnpack = (BoolUnpack)expr2;
                try {
                    DynamicExpr dynamicExpr;
                    inner = dynamicExpr = boolUnpack.inner();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                expr = ExprUtils.unpack(inner);
                return expr;
            }
            case 1: {
                DynamicExpr inner;
                NumberUnpack numberUnpack = (NumberUnpack)expr2;
                {
                    DynamicExpr dynamicExpr;
                    inner = dynamicExpr = numberUnpack.inner();
                }
                expr = ExprUtils.unpack(inner);
                return expr;
            }
            case 2: {
                DynamicExpr inner;
                StringUnpack stringUnpack = (StringUnpack)expr2;
                {
                    DynamicExpr dynamicExpr;
                    inner = dynamicExpr = stringUnpack.inner();
                }
                expr = ExprUtils.unpack(inner);
                return expr;
            }
            case 3: {
                Expr inner;
                DynamicCoerce dynamicCoerce = (DynamicCoerce)expr2;
                {
                    Expr expr3;
                    inner = expr3 = dynamicCoerce.inner();
                }
                expr = ExprUtils.unpack(inner);
                return expr;
            }
            case 4: {
                Expr inner;
                StringCoerce stringCoerce = (StringCoerce)expr2;
                {
                    Expr expr4;
                    inner = expr4 = stringCoerce.inner();
                }
                expr = ExprUtils.unpack(inner);
                return expr;
            }
        }
        expr = expression;
        return expr;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirect(Expr expr) {
        Expr expr2 = expr;
        Objects.requireNonNull(expr2);
        Expr expr3 = expr2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NullLiteral.class, StringLiteral.class, NumberLiteral.class, BoolLiteral.class, DynamicLiteral.class, DynamicCoerce.class, ObjectLiteral.class, Concatenate.class, BoolUnpack.class, NumberUnpack.class, StringUnpack.class, Bind.class, Call.class, Variable.class}, (Object)expr3, n)) {
            case 0: {
                NullLiteral ignored = (NullLiteral)expr3;
                return true;
            }
            case 1: {
                StringLiteral ignored = (StringLiteral)expr3;
                return true;
            }
            case 2: {
                NumberLiteral ignored = (NumberLiteral)expr3;
                return true;
            }
            case 3: {
                BoolLiteral ignored = (BoolLiteral)expr3;
                return true;
            }
            case 4: {
                boolean bl;
                DynamicLiteral dynamicLiteral = (DynamicLiteral)expr3;
                try {
                    Object object = dynamicLiteral.location();
                    CodeLocation location = object;
                    Object value = object = dynamicLiteral.content();
                    bl = value.isDirect();
                    return bl;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 5: {
                Expr inner;
                DynamicCoerce dynamicCoerce = (DynamicCoerce)expr3;
                {
                    Expr expr4;
                    inner = expr4 = dynamicCoerce.inner();
                }
                boolean bl = ExprUtils.isDirect(inner);
                return bl;
            }
            case 6: {
                boolean bl;
                ObjectLiteral objectLiteral = (ObjectLiteral)expr3;
                {
                    Object object = objectLiteral.location();
                    CodeLocation location = object;
                    Object content = object = objectLiteral.content();
                    bl = content.values().stream().allMatch(ExprUtils::isDirect);
                    return bl;
                }
            }
            case 7: {
                Object right;
                Object left;
                Concatenate concatenate = (Concatenate)expr3;
                {
                    Object object = concatenate.location();
                    CodeLocation location = object;
                    left = object = concatenate.left();
                    right = object = concatenate.right();
                }
                if (!ExprUtils.isDirect((Expr)left)) return false;
                if (!ExprUtils.isDirect((Expr)right)) return false;
                return true;
            }
            case 8: {
                DynamicExpr inner;
                BoolUnpack boolUnpack = (BoolUnpack)expr3;
                {
                    DynamicExpr dynamicExpr;
                    inner = dynamicExpr = boolUnpack.inner();
                }
                boolean bl = ExprUtils.isDirect(inner);
                return bl;
            }
            case 9: {
                DynamicExpr inner;
                NumberUnpack numberUnpack = (NumberUnpack)expr3;
                {
                    DynamicExpr dynamicExpr;
                    inner = dynamicExpr = numberUnpack.inner();
                }
                boolean bl = ExprUtils.isDirect(inner);
                return bl;
            }
            case 10: {
                DynamicExpr inner;
                StringUnpack stringUnpack = (StringUnpack)expr3;
                {
                    DynamicExpr dynamicExpr;
                    inner = dynamicExpr = stringUnpack.inner();
                }
                boolean bl = ExprUtils.isDirect(inner);
                return bl;
            }
            case 11: {
                Object parameter;
                Object callable;
                Bind bind = (Bind)expr3;
                {
                    Object object = bind.location();
                    CodeLocation location = object;
                    callable = object = bind.callable();
                    parameter = object = bind.parameter();
                }
                if (!ExprUtils.isDirect((Expr)callable)) return false;
                if (!ExprUtils.isDirect((Expr)parameter)) return false;
                return true;
            }
            case 12: {
                List<Call.Argument> args;
                List<Call.Argument> left;
                Call call = (Call)expr3;
                {
                    List<Call.Argument> list = call.location();
                    CodeLocation location = list;
                    left = list = call.callable();
                    args = list = call.arguments();
                }
                if (!ExprUtils.isDirect(left)) return false;
                if (!args.stream().allMatch(a -> !a.variadic() && ExprUtils.isDirect(a.value()))) return false;
                return true;
            }
            case 13: {
                boolean bl;
                Variable variable = (Variable)expr3;
                {
                    Object object = variable.location();
                    CodeLocation location = object;
                    Object name = object = variable.name();
                    bl = allowedVariables.contains(name);
                    return bl;
                }
            }
        }
        return false;
    }
}

