/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.ast;

import io.gitlab.jfronny.muscript.ast.BoolExpr;
import io.gitlab.jfronny.muscript.ast.DynamicExpr;
import io.gitlab.jfronny.muscript.ast.NullLiteral;
import io.gitlab.jfronny.muscript.ast.NumberExpr;
import io.gitlab.jfronny.muscript.ast.StringExpr;
import io.gitlab.jfronny.muscript.ast.bool.BoolLiteral;
import io.gitlab.jfronny.muscript.ast.number.NumberLiteral;
import io.gitlab.jfronny.muscript.ast.string.StringLiteral;
import io.gitlab.jfronny.muscript.core.CodeLocation;
import io.gitlab.jfronny.muscript.core.Order;

public sealed interface Expr
permits BoolExpr, DynamicExpr, NullLiteral, NumberExpr, StringExpr {
    public CodeLocation location();

    public Order order();

    public static BoolExpr literal(boolean bool) {
        return Expr.literal(null, bool);
    }

    public static StringExpr literal(String string) {
        return Expr.literal(null, string);
    }

    public static NumberExpr literal(double number) {
        return Expr.literal(null, number);
    }

    public static NullLiteral literalNull() {
        return Expr.literalNull(null);
    }

    public static BoolExpr literal(CodeLocation location, boolean bool) {
        return new BoolLiteral(location, bool);
    }

    public static StringExpr literal(CodeLocation location, String string) {
        return new StringLiteral(location, string);
    }

    public static NumberExpr literal(CodeLocation location, double number) {
        return new NumberLiteral(location, number);
    }

    public static NullLiteral literalNull(CodeLocation location) {
        return new NullLiteral(location);
    }
}

