/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats;

import com.zigythebird.playeranim.lib.mochafloats.MochaEngine;
import com.zigythebird.playeranim.lib.mochafloats.parser.MolangParser;
import com.zigythebird.playeranim.lib.mochafloats.parser.ParseException;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.FloatExpression;
import com.zigythebird.playeranim.lib.mochafloats.runtime.ExpressionInterpreter;
import com.zigythebird.playeranim.lib.mochafloats.runtime.MochaFunction;
import com.zigythebird.playeranim.lib.mochafloats.runtime.MolangCompiler;
import com.zigythebird.playeranim.lib.mochafloats.runtime.Scope;
import com.zigythebird.playeranim.lib.mochafloats.runtime.binding.JavaObjectBinding;
import com.zigythebird.playeranim.lib.mochafloats.runtime.compiled.MochaCompiledFunction;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.MutableObjectBinding;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.NumberValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Value;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javassist.ClassPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MochaEngineImpl<T>
implements MochaEngine<T> {
    private final Scope scope;
    private final T entity;
    private final MolangCompiler compiler;
    private Consumer<@NotNull ParseException> parseExceptionHandler;
    private boolean warnOnReflectiveFunctionUsage;

    public MochaEngineImpl(T entity, Consumer<Scope.Builder> scopeBuilder) {
        Scope.Builder builder = Scope.builder();
        scopeBuilder.accept(builder);
        this.scope = builder.build();
        this.entity = entity;
        this.compiler = new MolangCompiler(entity, this.getClass().getClassLoader(), this.scope);
    }

    @Override
    public float eval(@NotNull List<Expression> expressions) {
        Expression expression;
        if (expressions.size() == 1 && (expression = expressions.get(0)) instanceof FloatExpression) {
            FloatExpression expression2 = (FloatExpression)expression;
            return expression2.value();
        }
        Scope local = this.scope.copy();
        MutableObjectBinding temp = new MutableObjectBinding();
        local.set("temp", temp);
        local.set("t", temp);
        local.readOnly(true);
        ExpressionInterpreter<T> evaluator = new ExpressionInterpreter<T>(this.entity, local);
        evaluator.warnOnReflectiveFunctionUsage(this.warnOnReflectiveFunctionUsage);
        Value lastResult = NumberValue.zero();
        for (Expression expression3 : expressions) {
            lastResult = expression3.visit(evaluator);
            Value returnValue = evaluator.popReturnValue();
            if (returnValue == null) continue;
            lastResult = returnValue;
            break;
        }
        return lastResult == null ? 0.0f : lastResult.getAsNumber();
    }

    @Override
    public float eval(@NotNull Reader source) {
        List<Expression> parsed;
        try {
            parsed = this.parse(source);
        }
        catch (ParseException e) {
            if (this.parseExceptionHandler != null) {
                this.parseExceptionHandler.accept(e);
            }
            return 0.0f;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read from given reader", e);
        }
        return this.eval(parsed);
    }

    @Override
    @NotNull
    public MochaFunction prepareEval(@NotNull Reader reader) {
        List<Expression> parsed;
        try {
            parsed = this.parse(reader);
        }
        catch (ParseException e) {
            if (this.parseExceptionHandler != null) {
                this.parseExceptionHandler.accept(e);
            }
            return () -> 0.0f;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read from given reader", e);
        }
        return new MochaFunction(){

            @Override
            public float evaluate() {
                return MochaEngineImpl.this.eval(parsed);
            }

            @NotNull
            public String toString() {
                return "MochaPreparedFunction(" + String.valueOf(parsed) + ")";
            }
        };
    }

    @Override
    @NotNull
    public MochaFunction prepareEval(final @NotNull String code) {
        List<Expression> parsed;
        try {
            parsed = this.parse(code);
        }
        catch (ParseException e) {
            if (this.parseExceptionHandler != null) {
                this.parseExceptionHandler.accept(e);
            }
            return new MochaFunction(){

                @Override
                public float evaluate() {
                    return 0.0f;
                }

                @NotNull
                public String toString() {
                    return "MochaPreparedFunction('" + code + "', " + e.getMessage() + ")";
                }
            };
        }
        return new MochaFunction(){

            @Override
            public float evaluate() {
                return MochaEngineImpl.this.eval(parsed);
            }

            @NotNull
            public String toString() {
                return "MochaPreparedFunction(" + String.valueOf(parsed) + ")";
            }
        };
    }

    @Override
    @NotNull
    public <F extends MochaCompiledFunction> F compile(@NotNull Reader reader, @NotNull Class<F> interfaceType) {
        List<Expression> parsed;
        try {
            parsed = this.parse(reader);
        }
        catch (ParseException e) {
            if (this.parseExceptionHandler != null) {
                this.parseExceptionHandler.accept(e);
            }
            parsed = Collections.emptyList();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from given reader", e);
        }
        return this.compiler.compile(parsed, interfaceType);
    }

    @Override
    @NotNull
    public ClassPool classPool() {
        return this.compiler.classPool();
    }

    @Override
    @NotNull
    public Scope scope() {
        return this.scope;
    }

    @Override
    public void bind(@NotNull Class<?> clazz) {
        JavaObjectBinding javaObjectBinding = JavaObjectBinding.of(clazz, null, null);
        for (String name : javaObjectBinding.names()) {
            this.scope.set(name, javaObjectBinding);
        }
    }

    @Override
    public <B> void bindInstance(@NotNull Class<? super B> clazz, @NotNull B instance, @NotNull String name, String ... aliases) {
        JavaObjectBinding javaObjectBinding = JavaObjectBinding.of(clazz, instance, null);
        this.scope.set(name, javaObjectBinding);
        for (String alias : aliases) {
            this.scope.set(alias, javaObjectBinding);
        }
    }

    @Override
    @NotNull
    public List<Expression> parse(@NotNull Reader reader) throws IOException {
        return MolangParser.parser(reader).parseAll();
    }

    @Override
    @NotNull
    public MochaEngine<T> warnOnReflectiveFunctionUsage(boolean warnOnReflectiveFunctionUsage) {
        this.warnOnReflectiveFunctionUsage = warnOnReflectiveFunctionUsage;
        return this;
    }

    @Override
    @NotNull
    public MochaEngine<T> handleParseExceptions(@Nullable Consumer<@NotNull ParseException> exceptionHandler) {
        this.parseExceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    @NotNull
    public MochaEngine<T> postCompile(@Nullable Consumer<byte @NotNull []> bytecodeConsumer) {
        this.compiler.postCompile(bytecodeConsumer);
        return this;
    }
}

