/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranimcore.PlayerAnimLib;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4013;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerAnimResources
implements class_4013 {
    public static final class_2960 KEY = PlayerAnimLibMod.id("animation");
    private static final Map<class_2960, Animation> ANIMATIONS = new Object2ObjectOpenHashMap();

    @Nullable
    public static Animation getAnimation(class_2960 id) {
        if (!ANIMATIONS.containsKey(id)) {
            return null;
        }
        return ANIMATIONS.get(id);
    }

    @NotNull
    public static Optional<Animation> getAnimationOptional(@NotNull class_2960 identifier) {
        return Optional.ofNullable(PlayerAnimResources.getAnimation(identifier));
    }

    public static Map<class_2960, Animation> getAnimations() {
        return Collections.unmodifiableMap(ANIMATIONS);
    }

    @NotNull
    public static Map<String, Animation> getModAnimations(@NotNull String modid) {
        HashMap<String, Animation> map = new HashMap<String, Animation>();
        for (Map.Entry<class_2960, Animation> entry : ANIMATIONS.entrySet()) {
            if (!entry.getKey().method_12836().equals(modid)) continue;
            map.put(entry.getKey().method_12832(), entry.getValue());
        }
        return map;
    }

    public static boolean hasAnimation(class_2960 id) {
        return ANIMATIONS.containsKey(id);
    }

    public void method_14491(class_3300 manager) {
        ANIMATIONS.clear();
        for (Map.Entry resource : manager.method_14488("player_animations", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet()) {
            String namespace = ((class_2960)resource.getKey()).method_12836();
            try {
                InputStream is = ((class_3298)resource.getValue()).method_14482();
                try {
                    for (Map.Entry<String, Animation> entry : UniversalAnimLoader.loadAnimations(is).entrySet()) {
                        ANIMATIONS.put(class_2960.method_60655((String)namespace, (String)entry.getKey()), entry.getValue());
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                PlayerAnimLib.LOGGER.error("Player Animation Library failed to load animation {} because:", resource.getKey(), (Object)e);
            }
        }
    }

    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_4045 barrier, class_3300 manager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> this.method_14491(manager), backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)barrier).method_18352(arg_0));
    }
}

