/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.adjuster;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.api.MixinAnnotationAdjuster;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;

public final class MixinAnnotationAdjusterRegistrar {
    private static final Set<MixinAnnotationAdjuster> adjusters = new HashSet<MixinAnnotationAdjuster>();
    private static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared");

    public static AdjustableAnnotationNode adjust(List<String> targetClassNames, String mixinClassName, MethodNode handlerNode, AdjustableAnnotationNode annotationNode, BiConsumer<String, AdjustableAnnotationNode> postAdjustmentConsumer) {
        Iterator<MixinAnnotationAdjuster> iterator = adjusters.iterator();
        while (iterator.hasNext()) {
            MixinAnnotationAdjuster adjuster;
            String postAdjustment;
            String preAdjustment = annotationNode == null ? "null" : annotationNode.toString();
            if (preAdjustment.equals(postAdjustment = (annotationNode = (adjuster = iterator.next()).adjust(targetClassNames, mixinClassName, handlerNode, annotationNode)) == null ? "null" : annotationNode.toString())) continue;
            postAdjustmentConsumer.accept(adjuster.getClass().getName(), annotationNode);
        }
        return annotationNode;
    }

    public static void register(MixinAnnotationAdjuster adjuster) {
        adjusters.add(adjuster);
        LOGGER.debug("Registered annotation adjuster {}", new Object[]{adjuster.getClass().getName()});
    }
}

